/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.microsoft.sqlserver.jdbc.BaseAttestationResponse;
import com.microsoft.sqlserver.jdbc.JWTCertificateEntry;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResource;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.concurrent.ConcurrentHashMap;

class AASAttestationResponse
extends BaseAttestationResponse {
    private byte[] attestationToken;
    private static ConcurrentHashMap<String, JWTCertificateEntry> certificateCache = new ConcurrentHashMap();

    AASAttestationResponse(byte[] b) throws SQLServerException {
        ByteBuffer response2 = ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN);
        this.totalSize = response2.getInt();
        this.identitySize = response2.getInt();
        this.attestationTokenSize = response2.getInt();
        this.enclaveType = response2.getInt();
        this.enclavePK = new byte[this.identitySize];
        this.attestationToken = new byte[this.attestationTokenSize];
        response2.get(this.enclavePK, 0, this.identitySize);
        response2.get(this.attestationToken, 0, this.attestationTokenSize);
        this.sessionInfoSize = response2.getInt();
        response2.get(this.sessionID, 0, 8);
        this.dhpkSize = response2.getInt();
        this.dhpkSsize = response2.getInt();
        this.dhPublicKey = new byte[this.dhpkSize];
        this.publicKeySig = new byte[this.dhpkSsize];
        response2.get(this.dhPublicKey, 0, this.dhpkSize);
        response2.get(this.publicKeySig, 0, this.dhpkSsize);
        if (0 != response2.remaining()) {
            SQLServerException.makeFromDriverError(null, this, SQLServerResource.getResource("R_EnclaveResponseLengthError"), "0", false);
        }
    }

    void validateToken(String attestationUrl, byte[] nonce) throws SQLServerException {
        try {
            String jwtToken = new String(this.attestationToken).trim();
            if (jwtToken.startsWith("\"") && jwtToken.endsWith("\"")) {
                jwtToken = jwtToken.substring(1, jwtToken.length() - 1);
            }
            String[] splitString = jwtToken.split("\\.");
            Base64.Decoder decoder = Base64.getUrlDecoder();
            String header = new String(decoder.decode(splitString[0]));
            String body2 = new String(decoder.decode(splitString[1]));
            byte[] stmtSig = decoder.decode(splitString[2]);
            JsonArray keys2 = null;
            JWTCertificateEntry cacheEntry = certificateCache.get(attestationUrl);
            if (null != cacheEntry && !cacheEntry.expired()) {
                keys2 = cacheEntry.getCertificates();
            } else if (null != cacheEntry && cacheEntry.expired()) {
                certificateCache.remove(attestationUrl);
            }
            if (null == keys2) {
                String authorityUrl = new URL(attestationUrl).getAuthority();
                URL wellKnownUrl = new URL("https://" + authorityUrl + "/.well-known/openid-configuration");
                URLConnection con = wellKnownUrl.openConnection();
                String wellKnownUrlJson = Util.convertInputStreamToString(con.getInputStream());
                JsonObject attestationJson = JsonParser.parseString(wellKnownUrlJson).getAsJsonObject();
                URL jwksUrl = new URL(attestationJson.get("jwks_uri").getAsString());
                URLConnection jwksCon = jwksUrl.openConnection();
                String jwksUrlJson = Util.convertInputStreamToString(jwksCon.getInputStream());
                JsonObject jwksJson = JsonParser.parseString(jwksUrlJson).getAsJsonObject();
                keys2 = jwksJson.get("keys").getAsJsonArray();
                certificateCache.put(attestationUrl, new JWTCertificateEntry(keys2));
            }
            JsonObject headerJsonObject = JsonParser.parseString(header).getAsJsonObject();
            String keyID = headerJsonObject.get("kid").getAsString();
            for (JsonElement key : keys2) {
                JsonObject keyObj = key.getAsJsonObject();
                String kId = keyObj.get("kid").getAsString();
                if (!kId.equals(keyID)) continue;
                JsonArray certsFromServer = keyObj.get("x5c").getAsJsonArray();
                byte[] signatureBytes = (splitString[0] + "." + splitString[1]).getBytes();
                for (JsonElement jsonCert : certsFromServer) {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(jsonCert.getAsString())));
                    Signature sig = Signature.getInstance("SHA256withRSA");
                    sig.initVerify(cert.getPublicKey());
                    sig.update(signatureBytes);
                    if (!sig.verify(stmtSig)) continue;
                    JsonObject bodyJsonObject = JsonParser.parseString(body2).getAsJsonObject();
                    String aasEhd = bodyJsonObject.get("aas-ehd").getAsString();
                    if (!Arrays.equals(Base64.getUrlDecoder().decode(aasEhd), this.enclavePK)) {
                        SQLServerException.makeFromDriverError(null, this, SQLServerResource.getResource("R_AasEhdError"), "0", false);
                    }
                    if (this.enclaveType == 1) {
                        String rpData = bodyJsonObject.get("rp_data").getAsString();
                        if (!Arrays.equals(Base64.getUrlDecoder().decode(rpData), nonce)) {
                            SQLServerException.makeFromDriverError(null, this, SQLServerResource.getResource("R_VbsRpDataError"), "0", false);
                        }
                    }
                    return;
                }
            }
            SQLServerException.makeFromDriverError(null, this, SQLServerResource.getResource("R_AasJWTError"), "0", false);
        }
        catch (IOException | GeneralSecurityException e) {
            SQLServerException.makeFromDriverError(null, this, e.getLocalizedMessage(), "", false);
        }
    }

    void validateDHPublicKey(byte[] nonce) throws SQLServerException, GeneralSecurityException {
        if (this.enclaveType == 2) {
            for (int i = 0; i < this.enclavePK.length; ++i) {
                this.enclavePK[i] = (byte)(this.enclavePK[i] ^ nonce[i % nonce.length]);
            }
        }
        this.validateDHPublicKey();
    }
}

