/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.DaggerCollections;
import dagger.internal.DelegateFactory;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class AbstractMapFactory<K, V, V2>
implements Factory<Map<K, V2>> {
    private final Map<K, Provider<V>> contributingMap;

    AbstractMapFactory(Map<K, Provider<V>> map2) {
        this.contributingMap = Collections.unmodifiableMap(map2);
    }

    final Map<K, Provider<V>> contributingMap() {
        return this.contributingMap;
    }

    public static abstract class Builder<K, V, V2> {
        final LinkedHashMap<K, Provider<V>> map;

        Builder(int size) {
            this.map = DaggerCollections.newLinkedHashMapWithExpectedSize(size);
        }

        Builder<K, V, V2> put(K key, Provider<V> providerOfValue) {
            this.map.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(providerOfValue, "provider"));
            return this;
        }

        Builder<K, V, V2> putAll(Provider<Map<K, V2>> mapOfProviders) {
            if (mapOfProviders instanceof DelegateFactory) {
                DelegateFactory asDelegateFactory = (DelegateFactory)mapOfProviders;
                return this.putAll(asDelegateFactory.getDelegate());
            }
            AbstractMapFactory asAbstractMapFactory = (AbstractMapFactory)mapOfProviders;
            this.map.putAll(asAbstractMapFactory.contributingMap);
            return this;
        }
    }
}

