/*
 * Decompiled with CFR 0.152.
 */
package net.turqu.agent.device.impl;

import java.io.File;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.turqu.agent.device.CryptoEngine;
import net.turqu.agent.device.impl.DefaultCryptoEngineKt;
import net.turqu.model.TurquoiseAgentConfig;
import net.turqu.util.LoggerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/turqu/agent/device/impl/DelphiCryptoEngine;", "Lnet/turqu/agent/device/CryptoEngine;", "turquoiseAgentConfig", "Lnet/turqu/model/TurquoiseAgentConfig;", "<init>", "(Lnet/turqu/model/TurquoiseAgentConfig;)V", "encryptAES", "", "text", "key", "Ljava/security/Key;", "decryptAES", "encryptRSA", "exponent", "Ljava/math/BigInteger;", "modulus", "generateAES", "getCipher", "Ljavax/crypto/Cipher;", "instanceName", "mode", "", "getSecretKey", "Ljavax/crypto/spec/SecretKeySpec;", "myKey", "getPublicKey", "Ljava/security/PublicKey;", "base64PublicKey", "agent"})
@SourceDebugExtension(value={"SMAP\nDelphiCryptoEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelphiCryptoEngine.kt\nnet/turqu/agent/device/impl/DelphiCryptoEngine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class DelphiCryptoEngine
implements CryptoEngine {
    @NotNull
    private final TurquoiseAgentConfig turquoiseAgentConfig;

    @Inject
    public DelphiCryptoEngine(@NotNull TurquoiseAgentConfig turquoiseAgentConfig) {
        Intrinsics.checkNotNullParameter(turquoiseAgentConfig, "turquoiseAgentConfig");
        this.turquoiseAgentConfig = turquoiseAgentConfig;
    }

    @Override
    @NotNull
    public String encryptAES(@NotNull String text, @NotNull String key) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(key, "key");
        return DefaultCryptoEngineKt.encrypt(this.getCipher(this.getSecretKey(key), "AES/ECB/PKCS5PADDING", 1), text);
    }

    @Override
    @NotNull
    public String encryptAES(@NotNull String text, @NotNull Key key) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(key, "key");
        return DefaultCryptoEngineKt.encrypt(this.getCipher(key, "AES/ECB/PKCS5PADDING", 1), text);
    }

    @Override
    @NotNull
    public String decryptAES(@NotNull String text, @NotNull String key) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(key, "key");
        return DefaultCryptoEngineKt.decrypt(this.getCipher(this.getSecretKey(key), "AES/ECB/PKCS5PADDING", 2), text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String encryptRSA(@NotNull String text, @NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(key, "key");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String randomFileName = string;
        File file2 = new File(randomFileName);
        try {
            String[] stringArray = new String[]{"~~~"};
            object = CollectionsKt.take(StringsKt.split$default((CharSequence)key, stringArray, false, 0, 6, null), 2);
            String exponent = (String)object.get(0);
            String modulus = (String)object.get(1);
            Object object2 = new String[]{this.turquoiseAgentConfig.getRsaEncryptorExecutable(), text, exponent, modulus, randomFileName};
            Object $this$encryptRSA_u24lambda_u240 = object2 = Runtime.getRuntime().exec((String[])object2);
            boolean bl = false;
            ((Process)$this$encryptRSA_u24lambda_u240).waitFor(10L, TimeUnit.SECONDS);
            object = FilesKt.readText(file2, Charsets.UTF_8);
        }
        catch (Exception e) {
            LoggerKt.getLogger().error(e, DelphiCryptoEngine::encryptRSA$lambda$1);
            object = "";
        }
        finally {
            if (!file2.delete()) {
                LoggerKt.getLogger().error(() -> DelphiCryptoEngine.encryptRSA$lambda$2(randomFileName));
            }
        }
        return object;
    }

    @Override
    @NotNull
    public String encryptRSA(@NotNull String text, @NotNull BigInteger exponent, @NotNull BigInteger modulus) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(exponent, "exponent");
        Intrinsics.checkNotNullParameter(modulus, "modulus");
        return DefaultCryptoEngineKt.encrypt(this.getCipher(this.getPublicKey(exponent, modulus), "RSA/ECB/PKCS1Padding", 1), text);
    }

    @Override
    @NotNull
    public Key generateAES() {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey secretKey = keyGen.generateKey();
        Intrinsics.checkNotNullExpressionValue(secretKey, "generateKey(...)");
        return secretKey;
    }

    private final Cipher getCipher(Key key, String instanceName, int mode) {
        try {
            Cipher cipher;
            Cipher $this$getCipher_u24lambda_u243 = cipher = Cipher.getInstance(instanceName);
            boolean bl = false;
            $this$getCipher_u24lambda_u243.init(mode, key);
            Cipher cipher2 = cipher;
            Intrinsics.checkNotNullExpressionValue(cipher2, "apply(...)");
            return cipher2;
        }
        catch (Exception e) {
            LoggerKt.getLogger().error("Error while getting cipher", e);
            throw e;
        }
    }

    private final SecretKeySpec getSecretKey(String myKey) {
        try {
            byte[] byArray = MessageDigest.getInstance("SHA-1").digest(DefaultCryptoEngineKt.utf8Decoded(myKey));
            Intrinsics.checkNotNullExpressionValue(byArray, "digest(...)");
            byte[] byArray2 = byArray;
            int n = 16;
            byte[] byArray3 = Arrays.copyOf(byArray2, n);
            Intrinsics.checkNotNullExpressionValue(byArray3, "copyOf(...)");
            return new SecretKeySpec(byArray3, "AES");
        }
        catch (Exception e) {
            LoggerKt.getLogger().error("Error while generating AES key", e);
            throw e;
        }
    }

    private final PublicKey getPublicKey(String base64PublicKey) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(DefaultCryptoEngineKt.base64Decoded(base64PublicKey));
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(keySpec);
            Intrinsics.checkNotNullExpressionValue(publicKey, "generatePublic(...)");
            return publicKey;
        }
        catch (Exception e) {
            LoggerKt.getLogger().error("Error while generating Public key", e);
            throw e;
        }
    }

    private final PublicKey getPublicKey(BigInteger exponent, BigInteger modulus) {
        try {
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(keySpec);
            Intrinsics.checkNotNullExpressionValue(publicKey, "generatePublic(...)");
            return publicKey;
        }
        catch (Exception e) {
            LoggerKt.getLogger().error("Error while generating Public key", e);
            throw e;
        }
    }

    private static final Object encryptRSA$lambda$1() {
        return "Outsourced encryption failed";
    }

    private static final Object encryptRSA$lambda$2(String $randomFileName) {
        return "Could not delete file: " + $randomFileName;
    }
}

