/*
 * Decompiled with CFR 0.152.
 */
package net.turqu.agent.di;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import net.turqu.agent.Agent;
import net.turqu.agent.Agent_Factory;
import net.turqu.agent.device.CryptoEngine;
import net.turqu.agent.device.DatabaseEngine;
import net.turqu.agent.device.StatsProvider;
import net.turqu.agent.di.AgentComponent;
import net.turqu.agent.di.modules.DeviceModule;
import net.turqu.agent.di.modules.DeviceModule_ProvideDbEngineFactory;
import net.turqu.agent.di.modules.DeviceModule_ProvideDefaultCryptoEngineFactory;
import net.turqu.agent.di.modules.DeviceModule_ProvideDelphiCryptoEngineFactory;
import net.turqu.agent.di.modules.DeviceModule_ProvideStatsProviderFactory;
import net.turqu.agent.feature.notifiers.turquoiseSqlReports.TurquoiseSqlReportsNotifier;
import net.turqu.agent.feature.notifiers.turquoiseSqlReports.TurquoiseSqlReportsNotifier_Factory;
import net.turqu.agent.feature.responders.approval.ApprovalResponder;
import net.turqu.agent.feature.responders.approval.ApprovalResponder_Factory;
import net.turqu.agent.feature.responders.query.QueryResponder;
import net.turqu.agent.feature.responders.query.QueryResponder_Factory;
import net.turqu.agent.feature.responders.stats.StatsResponder;
import net.turqu.agent.feature.responders.stats.StatsResponder_Factory;
import net.turqu.agent.feature.responders.update.UpdateResponder_Factory;
import net.turqu.approval.ApprovalDatabaseModule;
import net.turqu.approval.ApprovalDatabaseModule_ProvideApprovalDatabaseFactory;
import net.turqu.approval.ApprovalManager;
import net.turqu.approval.ApprovalManager_Factory;
import net.turqu.approval.db.ApprovalDatabase;
import net.turqu.config.AgentConfigPath;
import net.turqu.config.ConfigModule;
import net.turqu.config.ConfigModule_ProvideConfigFactory;
import net.turqu.model.TurquoiseAgentConfig;

@DaggerGenerated
public final class DaggerAgentComponent {
    private DaggerAgentComponent() {
    }

    public static AgentComponent.Factory factory() {
        return new Factory();
    }

    private static final class AgentComponentImpl
    implements AgentComponent {
        private final AgentComponentImpl agentComponentImpl = this;
        Provider<AgentConfigPath> agentConfigPathProvider;
        Provider<TurquoiseAgentConfig> provideConfigProvider;
        Provider<StatsProvider> provideStatsProvider;
        Provider<StatsResponder> statsResponderProvider;
        Provider<DatabaseEngine> provideDbEngineProvider;
        Provider<CryptoEngine> provideDelphiCryptoEngineProvider;
        Provider<CryptoEngine> provideDefaultCryptoEngineProvider;
        Provider<ApprovalDatabase> provideApprovalDatabaseProvider;
        Provider<ApprovalManager> approvalManagerProvider;
        Provider<QueryResponder> queryResponderProvider;
        Provider<ApprovalResponder> approvalResponderProvider;
        Provider<TurquoiseSqlReportsNotifier> turquoiseSqlReportsNotifierProvider;
        Provider<Agent> agentProvider;

        AgentComponentImpl(DeviceModule deviceModuleParam, ConfigModule configModuleParam, ApprovalDatabaseModule approvalDatabaseModuleParam, AgentConfigPath agentConfigPathParam) {
            this.initialize(deviceModuleParam, configModuleParam, approvalDatabaseModuleParam, agentConfigPathParam);
        }

        private void initialize(DeviceModule deviceModuleParam, ConfigModule configModuleParam, ApprovalDatabaseModule approvalDatabaseModuleParam, AgentConfigPath agentConfigPathParam) {
            this.agentConfigPathProvider = InstanceFactory.create(agentConfigPathParam);
            this.provideConfigProvider = DoubleCheck.provider(ConfigModule_ProvideConfigFactory.create(configModuleParam, this.agentConfigPathProvider));
            this.provideStatsProvider = DoubleCheck.provider(DeviceModule_ProvideStatsProviderFactory.create(deviceModuleParam));
            this.statsResponderProvider = StatsResponder_Factory.create(this.provideStatsProvider);
            this.provideDbEngineProvider = DeviceModule_ProvideDbEngineFactory.create(deviceModuleParam, this.provideConfigProvider);
            this.provideDelphiCryptoEngineProvider = DeviceModule_ProvideDelphiCryptoEngineFactory.create(deviceModuleParam, this.provideConfigProvider);
            this.provideDefaultCryptoEngineProvider = DeviceModule_ProvideDefaultCryptoEngineFactory.create(deviceModuleParam);
            this.provideApprovalDatabaseProvider = DoubleCheck.provider(ApprovalDatabaseModule_ProvideApprovalDatabaseFactory.create(approvalDatabaseModuleParam, this.provideConfigProvider));
            this.approvalManagerProvider = DoubleCheck.provider(ApprovalManager_Factory.create(this.provideApprovalDatabaseProvider));
            this.queryResponderProvider = QueryResponder_Factory.create(this.provideDbEngineProvider, this.provideDelphiCryptoEngineProvider, this.provideDefaultCryptoEngineProvider, this.approvalManagerProvider, this.provideConfigProvider);
            this.approvalResponderProvider = ApprovalResponder_Factory.create(this.approvalManagerProvider, this.provideConfigProvider);
            this.turquoiseSqlReportsNotifierProvider = TurquoiseSqlReportsNotifier_Factory.create(this.provideDbEngineProvider, this.provideConfigProvider);
            this.agentProvider = DoubleCheck.provider(Agent_Factory.create(this.provideConfigProvider, this.statsResponderProvider, this.queryResponderProvider, this.approvalResponderProvider, this.turquoiseSqlReportsNotifierProvider, UpdateResponder_Factory.create()));
        }

        @Override
        public Agent agent() {
            return (Agent)this.agentProvider.get();
        }
    }

    private static final class Factory
    implements AgentComponent.Factory {
        private Factory() {
        }

        @Override
        public AgentComponent create(AgentConfigPath agentConfigPath) {
            Preconditions.checkNotNull(agentConfigPath);
            return new AgentComponentImpl(new DeviceModule(), new ConfigModule(), new ApprovalDatabaseModule(), agentConfigPath);
        }
    }
}

