/*
 * Decompiled with CFR 0.152.
 */
package net.turqu.agent.di.modules;

import dagger.Module;
import dagger.Provides;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import net.turqu.agent.device.CryptoEngine;
import net.turqu.agent.device.DatabaseEngine;
import net.turqu.agent.device.StatsProvider;
import net.turqu.agent.device.impl.DefaultCryptoEngine;
import net.turqu.agent.device.impl.DelphiCryptoEngine;
import net.turqu.agent.device.impl.SQLServerEngine;
import net.turqu.agent.device.impl.SQLiteEngine;
import net.turqu.agent.device.impl.StatsProviderImpl;
import net.turqu.model.DatabaseType;
import net.turqu.model.TurquoiseAgentConfig;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007J\b\u0010\u000b\u001a\u00020\tH\u0007J\b\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lnet/turqu/agent/di/modules/DeviceModule;", "", "<init>", "()V", "provideDbEngine", "Lnet/turqu/agent/device/DatabaseEngine;", "config", "Lnet/turqu/model/TurquoiseAgentConfig;", "provideDelphiCryptoEngine", "Lnet/turqu/agent/device/CryptoEngine;", "turquoiseAgentConfig", "provideDefaultCryptoEngine", "provideStatsProvider", "Lnet/turqu/agent/device/StatsProvider;", "agent"})
public final class DeviceModule {
    @Provides
    @NotNull
    public final DatabaseEngine provideDbEngine(@NotNull TurquoiseAgentConfig config2) {
        DatabaseEngine databaseEngine;
        Intrinsics.checkNotNullParameter(config2, "config");
        switch (WhenMappings.$EnumSwitchMapping$0[config2.getDatabase().getType().ordinal()]) {
            case 1: {
                databaseEngine = new SQLiteEngine(config2.getDatabase());
                break;
            }
            case 2: {
                databaseEngine = new SQLServerEngine(config2.getDatabase());
                break;
            }
            case 3: {
                throw new NotImplementedError(null, 1, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return databaseEngine;
    }

    @Provides
    @Named(value="Delphi")
    @NotNull
    public final CryptoEngine provideDelphiCryptoEngine(@NotNull TurquoiseAgentConfig turquoiseAgentConfig) {
        Intrinsics.checkNotNullParameter(turquoiseAgentConfig, "turquoiseAgentConfig");
        return new DelphiCryptoEngine(turquoiseAgentConfig);
    }

    @Provides
    @Named(value="Default")
    @NotNull
    public final CryptoEngine provideDefaultCryptoEngine() {
        return new DefaultCryptoEngine();
    }

    @Singleton
    @Provides
    @NotNull
    public final StatsProvider provideStatsProvider() {
        return new StatsProviderImpl();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            try {
                nArray[DatabaseType.sqlite.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.mssql.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.mysql.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

