/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.config;

import com.typesafe.config.Config;
import io.ktor.server.config.HoconDecoder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\r0\r0\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lio/ktor/server/config/HoconMapDecoder;", "Lio/ktor/server/config/HoconDecoder;", "Lcom/typesafe/config/Config;", "config", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "<init>", "(Lcom/typesafe/config/Config;Lkotlinx/serialization/modules/SerializersModule;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "", "decodeString", "()Ljava/lang/String;", "Lcom/typesafe/config/Config;", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "", "kotlin.jvm.PlatformType", "keys", "Ljava/util/List;", "ktor-server-core"})
public final class HoconMapDecoder
extends HoconDecoder {
    @NotNull
    private final Config config;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final List<String> keys;

    public HoconMapDecoder(@NotNull Config config2, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter(config2, "config");
        Intrinsics.checkNotNullParameter(serializersModule, "serializersModule");
        super(config2, "", serializersModule);
        this.config = config2;
        this.serializersModule = serializersModule;
        this.keys = CollectionsKt.toList(this.config.root().keySet());
    }

    public /* synthetic */ HoconMapDecoder(Config config2, SerializersModule serializersModule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            serializersModule = SerializersModuleBuildersKt.EmptySerializersModule();
        }
        this(config2, serializersModule);
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.getElementIndex() >= this.keys.size() * 2) {
            return -1;
        }
        int result2 = this.getElementIndex();
        if (this.getElementIndex() % 2 == 0) {
            String string = this.keys.get(this.getElementIndex() / 2);
            Intrinsics.checkNotNullExpressionValue(string, "get(...)");
            this.setCurrentPath(string);
        }
        int n = this.getElementIndex();
        this.setElementIndex(n + 1);
        return result2;
    }

    @Override
    @NotNull
    public String decodeString() {
        String string;
        if (this.getElementIndex() % 2 == 1) {
            string = this.getCurrentPath();
        } else {
            String string2 = this.config.getString(this.getCurrentPath());
            Intrinsics.checkNotNull(string2);
            string = string2;
        }
        return string;
    }
}

