/*
 * Decompiled with CFR 0.152.
 */
package net.turqu.approval;

import app.cash.sqldelight.ColumnAdapter;
import app.cash.sqldelight.db.AfterVersion;
import app.cash.sqldelight.db.QueryResult;
import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.driver.jdbc.sqlite.JdbcSqliteDriver;
import dagger.Module;
import dagger.Provides;
import java.util.Arrays;
import java.util.Date;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.turqu.approval.db.ApprovalDatabase;
import net.turqu.approval.db.ApprovalLog;
import net.turqu.model.TurquoiseAgentConfig;
import net.turqu.util.LoggerKt;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lnet/turqu/approval/ApprovalDatabaseModule;", "", "<init>", "()V", "provideApprovalDatabase", "Lnet/turqu/approval/db/ApprovalDatabase;", "turquoiseAgentConfig", "Lnet/turqu/model/TurquoiseAgentConfig;", "setVersion", "", "driver", "Lapp/cash/sqldelight/driver/jdbc/sqlite/JdbcSqliteDriver;", "version", "", "core"})
public final class ApprovalDatabaseModule {
    @Provides
    @Singleton
    @NotNull
    public final ApprovalDatabase provideApprovalDatabase(@NotNull TurquoiseAgentConfig turquoiseAgentConfig) {
        Intrinsics.checkNotNullParameter(turquoiseAgentConfig, "turquoiseAgentConfig");
        JdbcSqliteDriver driver = new JdbcSqliteDriver("jdbc:sqlite:" + turquoiseAgentConfig.getApproverFile(), null, 2, null);
        long currentVer = ((Number)driver.executeQuery(null, "PRAGMA user_version;", ApprovalDatabaseModule::provideApprovalDatabase$lambda$0, 0, null).getValue()).longValue();
        if (currentVer == 0L) {
            ApprovalDatabase.Companion.getSchema().create(driver);
            this.setVersion(driver, 1L);
            LoggerKt.getLogger().debug(ApprovalDatabaseModule::provideApprovalDatabase$lambda$1);
        } else {
            long schemaVer = ApprovalDatabase.Companion.getSchema().getVersion();
            if (schemaVer > currentVer) {
                ApprovalDatabase.Companion.getSchema().migrate(driver, currentVer, schemaVer, new AfterVersion[0]);
                this.setVersion(driver, schemaVer);
                LoggerKt.getLogger().debug("init: migrated from " + currentVer + " to " + schemaVer);
            } else {
                LoggerKt.getLogger().debug("init");
            }
        }
        return ApprovalDatabase.Companion.invoke(driver, new ApprovalLog.Adapter(new ColumnAdapter<Date, Long>(){

            public Date decode(long databaseValue) {
                return new Date(databaseValue);
            }

            public Long encode(Date value) {
                Intrinsics.checkNotNullParameter(value, "value");
                return value.getTime();
            }
        }));
    }

    private final void setVersion(JdbcSqliteDriver driver, long version) {
        String string = "PRAGMA user_version = %d;";
        Object[] objectArray = new Object[]{version};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        driver.execute(null, string2, 0, null);
    }

    private static final QueryResult provideApprovalDatabase$lambda$0(SqlCursor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Long l = it.getLong(0);
        return QueryResult.Value.box-impl(QueryResult.Value.constructor-impl(l != null ? l : 0L));
    }

    private static final Object provideApprovalDatabase$lambda$1() {
        return "init: created tables, setVersion to 1";
    }
}

