/*
 * Decompiled with CFR 0.152.
 */
package net.turqu.approval;

import app.cash.sqldelight.coroutines.FlowQuery;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import net.turqu.approval.db.Approval;
import net.turqu.approval.db.ApprovalDatabase;
import net.turqu.approval.db.ApprovalLog;
import net.turqu.model.ApprovalStatus;
import net.turqu.util.LoggerKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fJ\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fJ\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000bJ\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/turqu/approval/ApprovalManager;", "", "database", "Lnet/turqu/approval/db/ApprovalDatabase;", "<init>", "(Lnet/turqu/approval/db/ApprovalDatabase;)V", "writeLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getApprovalStatus", "Lnet/turqu/model/ApprovalStatus;", "query", "", "approvalRequested", "", "getWaitingQueries", "Lkotlinx/coroutines/flow/Flow;", "", "Lnet/turqu/approval/db/Approval;", "getApprovedQueries", "approve", "approvalId", "approveQuery", "disapprove", "logsOfApproval", "Lnet/turqu/approval/db/ApprovalLog;", "queryId", "core"})
public final class ApprovalManager {
    @NotNull
    private final ApprovalDatabase database;
    @NotNull
    private final ReentrantLock writeLock;

    @Inject
    public ApprovalManager(@NotNull ApprovalDatabase database) {
        Intrinsics.checkNotNullParameter(database, "database");
        this.database = database;
        this.writeLock = new ReentrantLock();
    }

    @NotNull
    public final ApprovalStatus getApprovalStatus(@NotNull String query) {
        ApprovalStatus approvalStatus;
        Intrinsics.checkNotNullParameter(query, "query");
        try {
            Long isApprovedFromDb = (Long)this.database.getApprovalDatabaseQueries().isApproved(query).executeAsOneOrNull();
            approvalStatus = isApprovedFromDb == null ? ApprovalStatus.NONE : (isApprovedFromDb > 0L ? ApprovalStatus.APPROVED : ApprovalStatus.QUEUED);
        }
        catch (SQLException e) {
            LoggerKt.getLogger().error(e.getMessage());
            approvalStatus = ApprovalStatus.NONE;
        }
        return approvalStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void approvalRequested(@NotNull String query) {
        Intrinsics.checkNotNullParameter(query, "query");
        Lock lock = this.writeLock;
        lock.lock();
        try {
            boolean bl = false;
            try {
                String string = UUID.nameUUIDFromBytes(StringsKt.encodeToByteArray(query)).toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                String uuid = string;
                this.database.getApprovalDatabaseQueries().insert(uuid, query, 0L);
                this.database.getApprovalDatabaseQueries().log(uuid, new Date());
            }
            catch (SQLException e) {
                LoggerKt.getLogger().error(e.getMessage());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public final Flow<List<Approval>> getWaitingQueries() {
        return FlowQuery.mapToList(FlowQuery.toFlow(this.database.getApprovalDatabaseQueries().getUnapprovedQueries()), EmptyCoroutineContext.INSTANCE);
    }

    @NotNull
    public final Flow<List<Approval>> getApprovedQueries() {
        return FlowQuery.mapToList(FlowQuery.toFlow(this.database.getApprovalDatabaseQueries().getApprovedQueries()), EmptyCoroutineContext.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void approve(@NotNull String approvalId) {
        Intrinsics.checkNotNullParameter(approvalId, "approvalId");
        Lock lock = this.writeLock;
        lock.lock();
        try {
            boolean bl = false;
            this.database.getApprovalDatabaseQueries().updateById(1L, approvalId);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void approveQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter(query, "query");
        Lock lock = this.writeLock;
        lock.lock();
        try {
            boolean bl = false;
            String string = UUID.nameUUIDFromBytes(StringsKt.encodeToByteArray(query)).toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String uuid = string;
            this.database.getApprovalDatabaseQueries().insert(uuid, query, 1L);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disapprove(@NotNull String approvalId) {
        Intrinsics.checkNotNullParameter(approvalId, "approvalId");
        Lock lock = this.writeLock;
        lock.lock();
        try {
            boolean bl = false;
            this.database.getApprovalDatabaseQueries().remove(approvalId);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public final Flow<List<ApprovalLog>> logsOfApproval(@NotNull String queryId) {
        Intrinsics.checkNotNullParameter(queryId, "queryId");
        return FlowQuery.mapToList(FlowQuery.toFlow(this.database.getApprovalDatabaseQueries().logs(queryId)), EmptyCoroutineContext.INSTANCE);
    }
}

