/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.CleanableDirectBuffer;
import io.netty.util.internal.Cleaner;
import io.netty.util.internal.PlatformDependent0;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;

final class CleanerJava24
implements Cleaner {
    private static final InternalLogger logger;
    private static final MethodHandle INVOKE_ALLOCATOR;

    CleanerJava24() {
    }

    static boolean isSupported() {
        return INVOKE_ALLOCATOR != null;
    }

    @Override
    public CleanableDirectBuffer allocate(int capacity) {
        try {
            return INVOKE_ALLOCATOR.invokeExact(capacity);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unexpected allocation exception", e);
        }
    }

    @Override
    public void freeDirectBuffer(ByteBuffer buffer) {
        throw new UnsupportedOperationException("Cannot clean arbitrary ByteBuffer instances");
    }

    static {
        Throwable error;
        MethodHandle method;
        logger = InternalLoggerFactory.getInstance(CleanerJava24.class);
        if (PlatformDependent0.javaVersion() >= 24) {
            try {
                Class<?> arenaCls = Class.forName("java.lang.foreign.Arena");
                Class<?> memsegCls = Class.forName("java.lang.foreign.MemorySegment");
                Class<CleanableDirectBufferImpl> bufCls = CleanableDirectBufferImpl.class;
                MethodHandles.Lookup lookup2 = MethodHandles.lookup();
                MethodHandle ofShared = lookup2.findStatic(arenaCls, "ofShared", MethodType.methodType(arenaCls));
                MethodHandle allocate = lookup2.findVirtual(arenaCls, "allocate", MethodType.methodType(memsegCls, Long.TYPE));
                MethodHandle asByteBuffer = lookup2.findVirtual(memsegCls, "asByteBuffer", MethodType.methodType(ByteBuffer.class));
                MethodHandle bufClsCtor = lookup2.findConstructor(bufCls, MethodType.methodType(Void.TYPE, AutoCloseable.class, ByteBuffer.class));
                MethodHandle allocateInt = MethodHandles.explicitCastArguments(allocate, MethodType.methodType(memsegCls, arenaCls, Integer.TYPE));
                MethodHandle ctorArenaMemseg = MethodHandles.explicitCastArguments(MethodHandles.filterArguments(bufClsCtor, 1, asByteBuffer), MethodType.methodType(bufCls, arenaCls, memsegCls));
                MethodHandle ctorArenaArenaInt = MethodHandles.collectArguments(ctorArenaMemseg, 1, allocateInt);
                MethodHandle ctorArenaNullInt = MethodHandles.permuteArguments(ctorArenaArenaInt, MethodType.methodType(bufCls, arenaCls, arenaCls, Integer.TYPE), 0, 0, 2);
                MethodHandle ctorArenaInt = MethodHandles.insertArguments(ctorArenaNullInt, 1, new Object[]{null});
                method = MethodHandles.foldArguments(ctorArenaInt, ofShared);
                error = null;
            }
            catch (Throwable throwable) {
                method = null;
                error = throwable;
            }
        } else {
            method = null;
            error = new UnsupportedOperationException("java.lang.foreign.MemorySegment unavailable");
        }
        if (error == null) {
            logger.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", error);
        }
        INVOKE_ALLOCATOR = method;
    }

    private static final class CleanableDirectBufferImpl
    implements CleanableDirectBuffer {
        private final AutoCloseable closeable;
        private final ByteBuffer buffer;

        CleanableDirectBufferImpl(AutoCloseable closeable, ByteBuffer buffer) {
            this.closeable = closeable;
            this.buffer = buffer;
        }

        @Override
        public ByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public void clean() {
            try {
                this.closeable.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected close exception", e);
            }
        }
    }
}

