/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.response;

import io.ktor.http.Cookie;
import io.ktor.http.CookieEncoding;
import io.ktor.http.CookieKt;
import io.ktor.server.response.PipelineResponse;
import io.ktor.server.response.ResponseHeaders;
import io.ktor.util.date.GMTDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0083\u0001\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u00182\u0016\b\u0002\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001b\u00a2\u0006\u0004\b\r\u0010\u001dJ/\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 \u00a8\u0006!"}, d2={"Lio/ktor/server/response/ResponseCookies;", "", "Lio/ktor/server/response/PipelineResponse;", "response", "<init>", "(Lio/ktor/server/response/PipelineResponse;)V", "", "name", "Lio/ktor/http/Cookie;", "get", "(Ljava/lang/String;)Lio/ktor/http/Cookie;", "item", "", "append", "(Lio/ktor/http/Cookie;)V", "value", "Lio/ktor/http/CookieEncoding;", "encoding", "", "maxAge", "Lio/ktor/util/date/GMTDate;", "expires", "domain", "path", "", "secure", "httpOnly", "", "extensions", "(Ljava/lang/String;Ljava/lang/String;Lio/ktor/http/CookieEncoding;Ljava/lang/Long;Lio/ktor/util/date/GMTDate;Ljava/lang/String;Ljava/lang/String;ZZLjava/util/Map;)V", "appendExpired", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lio/ktor/server/response/PipelineResponse;", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nResponseCookies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseCookies.kt\nio/ktor/server/response/ResponseCookies\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1563#2:88\n1634#2,3:89\n295#2,2:92\n*S KotlinDebug\n*F\n+ 1 ResponseCookies.kt\nio/ktor/server/response/ResponseCookies\n*L\n25#1:88\n25#1:89,3\n26#1:92,2\n*E\n"})
public final class ResponseCookies {
    @NotNull
    private final PipelineResponse response;

    public ResponseCookies(@NotNull PipelineResponse response2) {
        Intrinsics.checkNotNullParameter(response2, "response");
        this.response = response2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Cookie get(@NotNull String name) {
        Object v0;
        block2: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(name, "name");
            Iterable $this$map$iv = this.response.getHeaders().values("Set-Cookie");
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CookieKt.parseServerSetCookieHeader((String)it));
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Cookie it = (Cookie)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), name)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    public final void append(@NotNull Cookie item) {
        Intrinsics.checkNotNullParameter(item, "item");
        ResponseHeaders.append$default(this.response.getHeaders(), "Set-Cookie", CookieKt.renderSetCookieHeader(item), false, 4, null);
    }

    public final void append(@NotNull String name, @NotNull String value, @NotNull CookieEncoding encoding, @Nullable Long maxAge, @Nullable GMTDate expires, @Nullable String domain, @Nullable String path, boolean secure, boolean httpOnly, @NotNull Map<String, String> extensions) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        Long l = maxAge;
        this.append(new Cookie(name, value, encoding, l != null ? Integer.valueOf((int)RangesKt.coerceAtMost(l, Integer.MAX_VALUE)) : null, expires, domain, path, secure, httpOnly, extensions));
    }

    public static /* synthetic */ void append$default(ResponseCookies responseCookies, String string, String string2, CookieEncoding cookieEncoding, Long l, GMTDate gMTDate, String string3, String string4, boolean bl, boolean bl2, Map map2, int n, Object object) {
        if ((n & 4) != 0) {
            cookieEncoding = CookieEncoding.URI_ENCODING;
        }
        if ((n & 8) != 0) {
            l = null;
        }
        if ((n & 0x10) != 0) {
            gMTDate = null;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        if ((n & 0x40) != 0) {
            string4 = null;
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        if ((n & 0x100) != 0) {
            bl2 = false;
        }
        if ((n & 0x200) != 0) {
            map2 = MapsKt.emptyMap();
        }
        responseCookies.append(string, string2, cookieEncoding, l, gMTDate, string3, string4, bl, bl2, map2);
    }

    @Deprecated(message="This method doesn't bypass all flags and extensions so it will be removed in future major release. Please consider using append with expires parameter instead.", replaceWith=@ReplaceWith(expression="append(name, \"\", CookieEncoding.URI_ENCODING, 0, GMTDate(), domain, path, secure, httpOnly, extensions)", imports={}), level=DeprecationLevel.ERROR)
    public final void appendExpired(@NotNull String name, @Nullable String domain, @Nullable String path) {
        Intrinsics.checkNotNullParameter(name, "name");
        GMTDate gMTDate = GMTDate.Companion.getSTART();
        ResponseCookies.append$default(this, name, "", null, null, gMTDate, domain, path, false, false, null, 908, null);
    }

    public static /* synthetic */ void appendExpired$default(ResponseCookies responseCookies, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        responseCookies.appendExpired(string, string2, string3);
    }
}

