/*
 * Decompiled with CFR 0.152.
 */
package net.turqu.agent.util;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\t"}, d2={"Lnet/turqu/agent/util/SystemTrayManager;", "", "<init>", "()V", "setup", "", "createTrayIconImage", "Ljava/awt/image/BufferedImage;", "openDashboard", "agent"})
public final class SystemTrayManager {
    @NotNull
    public static final SystemTrayManager INSTANCE = new SystemTrayManager();

    private SystemTrayManager() {
    }

    public final void setup() {
        try {
            if (!SystemTray.isSupported()) {
                System.err.println("System Tray not supported");
                return;
            }
            SystemTray tray = SystemTray.getSystemTray();
            BufferedImage image = this.createTrayIconImage();
            PopupMenu popup = new PopupMenu();
            MenuItem openItem = new MenuItem("Open Dashboard");
            openItem.addActionListener(SystemTrayManager::setup$lambda$0);
            MenuItem exitItem = new MenuItem("Exit");
            exitItem.addActionListener(SystemTrayManager::setup$lambda$1);
            popup.add(openItem);
            popup.addSeparator();
            popup.add(exitItem);
            TrayIcon trayIcon = new TrayIcon(image, "Turquoise Agent", popup);
            trayIcon.setImageAutoSize(true);
            trayIcon.addActionListener(SystemTrayManager::setup$lambda$2);
            trayIcon.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter(e, "e");
                    if (e.getButton() == 1) {
                        SystemTrayManager.access$openDashboard(SystemTrayManager.INSTANCE);
                    }
                }
            });
            tray.add(trayIcon);
        }
        catch (Exception e) {
            System.err.println("Failed to initialize System Tray: " + e.getMessage());
        }
    }

    private final BufferedImage createTrayIconImage() {
        BufferedImage image = new BufferedImage(16, 16, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.WHITE);
        g.fillOval(0, 0, 16, 16);
        g.setColor(new Color(64, 224, 208));
        g.setFont(new Font("SansSerif", 1, 12));
        g.drawString("T", 4, 13);
        g.dispose();
        return image;
    }

    private final void openDashboard() {
        String url2 = "http://localhost:8977";
        try {
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            String os = string2;
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI(url2));
            } else if (StringsKt.contains$default((CharSequence)os, "nix", false, 2, null) || StringsKt.contains$default((CharSequence)os, "nux", false, 2, null)) {
                String[] stringArray = new String[]{"xdg-open", url2};
                Runtime.getRuntime().exec(stringArray);
            } else if (StringsKt.contains$default((CharSequence)os, "mac", false, 2, null)) {
                String[] stringArray = new String[]{"open", url2};
                Runtime.getRuntime().exec(stringArray);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to open browser via Desktop: " + e.getMessage());
            try {
                String string = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
                String string3 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                String os = string3;
                if (StringsKt.contains$default((CharSequence)os, "nix", false, 2, null) || StringsKt.contains$default((CharSequence)os, "nux", false, 2, null)) {
                    String[] stringArray = new String[]{"xdg-open", url2};
                    Runtime.getRuntime().exec(stringArray);
                }
            }
            catch (Exception ex) {
                System.err.println("Fallback failed: " + ex.getMessage());
            }
        }
    }

    private static final void setup$lambda$0(ActionEvent it) {
        INSTANCE.openDashboard();
    }

    private static final void setup$lambda$1(ActionEvent it) {
        System.exit(0);
    }

    private static final void setup$lambda$2(ActionEvent it) {
        INSTANCE.openDashboard();
    }

    public static final /* synthetic */ void access$openDashboard(SystemTrayManager $this) {
        $this.openDashboard();
    }
}

