/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.config;

import io.ktor.server.config.AbstractMapConfigDecoder;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0015R\u001a\u0010\t\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lio/ktor/server/config/ListMapConfigDecoder;", "Lio/ktor/server/config/AbstractMapConfigDecoder;", "", "", "map", "path", "", "size", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "<init>", "(Ljava/util/Map;Ljava/lang/String;ILkotlinx/serialization/modules/SerializersModule;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "decodeString", "()Ljava/lang/String;", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "I", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "index", "ktor-server-core"})
final class ListMapConfigDecoder
extends AbstractMapConfigDecoder {
    private final int size;
    @NotNull
    private final SerializersModule serializersModule;
    private int index;

    public ListMapConfigDecoder(@NotNull Map<String, String> map2, @NotNull String path, int size, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter(map2, "map");
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(serializersModule, "serializersModule");
        super(map2, path, serializersModule);
        this.size = size;
        this.serializersModule = serializersModule;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int n;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.index < this.size) {
            int n2 = this.index;
            this.index = n2 + 1;
            n = n2;
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    @NotNull
    public String decodeString() {
        String key = this.getPath() + '.' + (this.index - 1);
        String string = this.getMap().get(key);
        if (string == null) {
            throw new SerializationException("Missing list element at \"" + key + '\"');
        }
        return string;
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return this.beginStructure(descriptor2, this.getPath() + '.' + (this.index - 1));
    }
}

