/*
 * Decompiled with CFR 0.152.
 */
package net.turqu.agent.ui;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import net.turqu.agent.Agent;
import net.turqu.agent.di.AgentComponent;
import net.turqu.agent.di.DaggerAgentComponent;
import net.turqu.model.TurquoiseAgentConfig;
import net.turqu.util.ExtensionsKt;
import net.turqu.util.LoggerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0014J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\bJ\u0016\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lnet/turqu/agent/ui/AgentManager;", "", "<init>", "()V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "agents", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lnet/turqu/agent/ui/AgentManager$AgentEntry;", "persistenceFile", "Ljava/io/File;", "loadPersistedConfigs", "", "savePersistedConfigs", "importConfig", "config", "Lnet/turqu/model/TurquoiseAgentConfig;", "addLegacyConfig", "getAgentStatuses", "", "Lnet/turqu/agent/ui/AgentManager$AgentStatus;", "getAgents", "startAgent", "id", "stopAgent", "deleteAgent", "updateAgent", "AgentEntry", "AgentStatus", "agent"})
@SourceDebugExtension(value={"SMAP\nAgentManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentManager.kt\nnet/turqu/agent/ui/AgentManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n1869#2,2:344\n774#2:346\n865#2,2:347\n1761#2,3:349\n1761#2,3:352\n1563#2:355\n1634#2,2:356\n295#2,2:358\n1636#2:360\n1761#2,3:361\n*S KotlinDebug\n*F\n+ 1 AgentManager.kt\nnet/turqu/agent/ui/AgentManager\n*L\n66#1:344,2\n84#1:346\n84#1:347,2\n96#1:349,3\n111#1:352,3\n125#1:355\n125#1:356,2\n129#1:358,2\n125#1:360\n149#1:361,3\n*E\n"})
public final class AgentManager {
    @NotNull
    private final CoroutineScope scope = CoroutineScopeKt.CoroutineScope(SupervisorKt.SupervisorJob$default(null, 1, null).plus(Dispatchers.getIO()));
    @NotNull
    private final ConcurrentHashMap<String, AgentEntry> agents = new ConcurrentHashMap();
    @NotNull
    private final File persistenceFile = new File("agents.json");

    public AgentManager() {
        this.loadPersistedConfigs();
    }

    private final void loadPersistedConfigs() {
        if (this.persistenceFile.exists()) {
            try {
                Type type2 = new TypeToken<List<? extends AgentEntry>>(){}.getType();
                Object t = ExtensionsKt.getGson().fromJson(FilesKt.readText$default(this.persistenceFile, null, 1, null), type2);
                Intrinsics.checkNotNullExpressionValue(t, "fromJson(...)");
                List entries2 = (List)t;
                Iterable $this$forEach$iv = entries2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AgentEntry it = (AgentEntry)element$iv;
                    boolean bl = false;
                    ((Map)this.agents).put(it.getId(), it);
                    try {
                        this.startAgent(it.getId());
                    }
                    catch (Exception e) {
                        LoggerKt.getLogger().error(e, () -> AgentManager.loadPersistedConfigs$lambda$1$lambda$0(it));
                    }
                }
            }
            catch (Exception e) {
                LoggerKt.getLogger().error(e, AgentManager::loadPersistedConfigs$lambda$2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void savePersistedConfigs() {
        try {
            void $this$filterTo$iv$iv;
            Collection<AgentEntry> collection = this.agents.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AgentEntry it = (AgentEntry)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getSource(), "imported")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List entries2 = CollectionsKt.toList((List)destination$iv$iv);
            File file2 = this.persistenceFile;
            synchronized (file2) {
                boolean bl = false;
                String string = ExtensionsKt.getGson().toJson(entries2);
                Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
                FilesKt.writeText$default(this.persistenceFile, string, null, 2, null);
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            LoggerKt.getLogger().error(e, AgentManager::savePersistedConfigs$lambda$5);
        }
    }

    public final void importConfig(@NotNull TurquoiseAgentConfig config2) {
        boolean exists;
        block6: {
            boolean bl;
            Intrinsics.checkNotNullParameter(config2, "config");
            Collection<AgentEntry> collection = this.agents.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AgentEntry it = (AgentEntry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getConfig(), config2)) continue;
                    bl = true;
                    break block6;
                }
                bl = exists = false;
            }
        }
        if (!exists) {
            AgentEntry entry = new AgentEntry(config2, null, null, null, "imported", 14, null);
            ((Map)this.agents).put(entry.getId(), entry);
            this.savePersistedConfigs();
            try {
                this.startAgent(entry.getId());
            }
            catch (Exception e) {
                LoggerKt.getLogger().error(e, () -> AgentManager.importConfig$lambda$7(entry));
            }
        }
    }

    public final void addLegacyConfig(@NotNull TurquoiseAgentConfig config2) {
        boolean exists;
        block6: {
            boolean bl;
            Intrinsics.checkNotNullParameter(config2, "config");
            Collection<AgentEntry> collection = this.agents.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AgentEntry it = (AgentEntry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getConfig(), config2)) continue;
                    bl = true;
                    break block6;
                }
                bl = exists = false;
            }
        }
        if (!exists) {
            AgentEntry entry = new AgentEntry(config2, null, null, null, "legacy", 14, null);
            ((Map)this.agents).put(entry.getId(), entry);
            try {
                this.startAgent(entry.getId());
            }
            catch (Exception e) {
                LoggerKt.getLogger().error(e, () -> AgentManager.addLegacyConfig$lambda$9(entry));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<AgentStatus> getAgentStatuses() {
        v0 = this.agents.values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        $this$map$iv = v0;
        $i$f$map = false;
        var3_3 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            block8: {
                block7: {
                    block6: {
                        var8_8 = (AgentEntry)item$iv$iv;
                        var19_19 = destination$iv$iv;
                        $i$a$-map-AgentManager$getAgentStatuses$1 = false;
                        v1 = entry.getAgentInstance();
                        if (v1 == null || (v1 = v1.getConnectionState()) == null || (v1 = v1.name()) == null) {
                            v1 = "STOPPED";
                        }
                        if (!Intrinsics.areEqual(status = v1, "STOPPED")) break block7;
                        v2 = this.agents.values();
                        Intrinsics.checkNotNullExpressionValue(v2, "<get-values>(...)");
                        $this$firstOrNull$iv = v2;
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            running = (AgentEntry)element$iv;
                            $i$a$-firstOrNull-AgentManager$getAgentStatuses$1$duplicateOf$1 = false;
                            if (Intrinsics.areEqual(running.getId(), entry.getId())) ** GOTO lbl-1000
                            v3 = running.getAgentInstance();
                            if (v3 == null || (v3 = v3.getConnectionState()) == null || (v3 = v3.name()) == null) {
                                v3 = "STOPPED";
                            }
                            if (!Intrinsics.areEqual(v3, "STOPPED") && Intrinsics.areEqual(running.getConfig().getEnvironment().getAddress(), entry.getConfig().getEnvironment().getAddress()) && Intrinsics.areEqual(running.getConfig().getLicense().getUsername(), entry.getConfig().getLicense().getUsername())) {
                                v4 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v4 = false;
                            }
                            if (!v4) continue;
                            v5 = element$iv;
                            break block6;
                        }
                        v5 = null;
                    }
                    var17_17 = v5;
                    v6 = var17_17 != null ? var17_17.getId() : null;
                    break block8;
                }
                v6 = null;
            }
            duplicateOf = v6;
            var19_19.add(new AgentStatus(entry.getId(), entry.getConfig(), (String)status, duplicateOf, entry.getSource()));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<AgentEntry> getAgents() {
        Collection<AgentEntry> collection = this.agents.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    /*
     * Unable to fully structure code
     */
    public final void startAgent(@NotNull String id) {
        block6: {
            block7: {
                Intrinsics.checkNotNullParameter(id, "id");
                v0 = this.agents.get(id);
                if (v0 == null) {
                    return;
                }
                entry = v0;
                v1 = entry.getJob();
                v2 = v1 != null ? v1.isActive() : false;
                if (v2) {
                    return;
                }
                targetConfig = entry.getConfig();
                v3 = this.agents.values();
                Intrinsics.checkNotNullExpressionValue(v3, "<get-values>(...)");
                $this$any$iv = v3;
                $i$f$any = false;
                if (!((Collection)$this$any$iv).isEmpty()) break block7;
                v4 = false;
                break block6;
            }
            for (T element$iv : $this$any$iv) {
                other = (AgentEntry)element$iv;
                $i$a$-any-AgentManager$startAgent$duplicateRunning$1 = false;
                if (Intrinsics.areEqual(other.getId(), id)) ** GOTO lbl-1000
                v5 = other.getJob();
                v6 = v5 != null ? v5.isActive() : false;
                if (v6 && Intrinsics.areEqual(other.getConfig().getEnvironment().getAddress(), targetConfig.getEnvironment().getAddress()) && Intrinsics.areEqual(other.getConfig().getLicense().getUsername(), targetConfig.getLicense().getUsername())) {
                    v7 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v7 = false;
                }
                if (!v7) continue;
                v4 = true;
                break block6;
            }
            v4 = duplicateRunning = false;
        }
        if (duplicateRunning) {
            throw new IllegalStateException("Another agent with username '" + targetConfig.getLicense().getUsername() + "' on environment '" + targetConfig.getEnvironment().getAddress() + "' is already running.");
        }
        LoggerKt.getLogger().info((Function0<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, startAgent$lambda$13(java.lang.String ), ()Ljava/lang/Object;)((String)id));
        job = BuildersKt.launch$default(this.scope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(entry, id, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ AgentEntry $entry;
            final /* synthetic */ String $id;
            {
                this.$entry = $entry;
                this.$id = $id;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        try {
                            component = DaggerAgentComponent.factory().create(this.$entry.getConfig());
                            agent = component.agent();
                            this.$entry.setAgentInstance(agent);
                            this.L$0 = SpillingKt.nullOutSpilledVariable(component);
                            this.L$1 = SpillingKt.nullOutSpilledVariable(agent);
                            this.label = 1;
                            v0 = agent.run(this);
                            v1 = v0;
                        }
                        catch (CancellationException e) {
                            throw e;
                            catch (Exception e) {
                                LoggerKt.getLogger().error(e, (Function0<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(java.lang.String ), ()Ljava/lang/Object;)((String)this.$id));
                                return Unit.INSTANCE;
                            }
                        }
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl33
                    }
                    case 1: {
                        agent = (Agent)this.L$1;
                        component = (AgentComponent)this.L$0;
                        {
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
                        }
lbl33:
                        // 2 sources

                        this.$entry.setAgentInstance(null);
                        return Unit.INSTANCE;
                    }
                }
                finally {
                    this.$entry.setAgentInstance(null);
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Object invokeSuspend$lambda$0(String $id) {
                return "Agent " + $id + " failed";
            }
        }, 3, null);
        entry.setJob(job);
    }

    public final void stopAgent(@NotNull String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        AgentEntry agentEntry = this.agents.get(id);
        if (agentEntry == null) {
            return;
        }
        AgentEntry entry = agentEntry;
        Job job2 = entry.getJob();
        if (job2 != null) {
            Job.DefaultImpls.cancel$default(job2, null, 1, null);
        }
        entry.setJob(null);
        LoggerKt.getLogger().info(() -> AgentManager.stopAgent$lambda$14(id));
    }

    public final void deleteAgent(@NotNull String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        this.stopAgent(id);
        this.agents.remove(id);
        this.savePersistedConfigs();
    }

    public final void updateAgent(@NotNull String id, @NotNull TurquoiseAgentConfig config2) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(config2, "config");
        AgentEntry agentEntry = this.agents.get(id);
        if (agentEntry == null) {
            return;
        }
        AgentEntry oldEntry = agentEntry;
        this.stopAgent(id);
        AgentEntry newEntry = AgentEntry.copy$default(oldEntry, config2, null, null, null, null, 30, null);
        ((Map)this.agents).put(id, newEntry);
        this.savePersistedConfigs();
        this.startAgent(id);
    }

    private static final Object loadPersistedConfigs$lambda$1$lambda$0(AgentEntry $it) {
        return "Failed to auto-start agent " + $it.getId();
    }

    private static final Object loadPersistedConfigs$lambda$2() {
        return "Failed to load agents.json";
    }

    private static final Object savePersistedConfigs$lambda$5() {
        return "Failed to save agents.json";
    }

    private static final Object importConfig$lambda$7(AgentEntry $entry) {
        return "Failed to start imported agent " + $entry.getId();
    }

    private static final Object addLegacyConfig$lambda$9(AgentEntry $entry) {
        return "Failed to start legacy agent " + $entry.getId();
    }

    private static final Object startAgent$lambda$13(String $id) {
        return "Starting agent " + $id;
    }

    private static final Object stopAgent$lambda$14(String $id) {
        return "Stopped agent " + $id;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J?\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018\u00a8\u0006&"}, d2={"Lnet/turqu/agent/ui/AgentManager$AgentEntry;", "", "config", "Lnet/turqu/model/TurquoiseAgentConfig;", "job", "Lkotlinx/coroutines/Job;", "agentInstance", "Lnet/turqu/agent/Agent;", "id", "", "source", "<init>", "(Lnet/turqu/model/TurquoiseAgentConfig;Lkotlinx/coroutines/Job;Lnet/turqu/agent/Agent;Ljava/lang/String;Ljava/lang/String;)V", "getConfig", "()Lnet/turqu/model/TurquoiseAgentConfig;", "getJob", "()Lkotlinx/coroutines/Job;", "setJob", "(Lkotlinx/coroutines/Job;)V", "getAgentInstance", "()Lnet/turqu/agent/Agent;", "setAgentInstance", "(Lnet/turqu/agent/Agent;)V", "getId", "()Ljava/lang/String;", "getSource", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "agent"})
    public static final class AgentEntry {
        @NotNull
        private final TurquoiseAgentConfig config;
        @Nullable
        private transient Job job;
        @Nullable
        private transient Agent agentInstance;
        @NotNull
        private final String id;
        @NotNull
        private final String source;

        public AgentEntry(@NotNull TurquoiseAgentConfig config2, @Nullable Job job2, @Nullable Agent agentInstance, @NotNull String id, @NotNull String source) {
            Intrinsics.checkNotNullParameter(config2, "config");
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter(source, "source");
            this.config = config2;
            this.job = job2;
            this.agentInstance = agentInstance;
            this.id = id;
            this.source = source;
        }

        public /* synthetic */ AgentEntry(TurquoiseAgentConfig turquoiseAgentConfig, Job job2, Agent agent, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                job2 = null;
            }
            if ((n & 4) != 0) {
                agent = null;
            }
            if ((n & 8) != 0) {
                String string3 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
                string = string3;
            }
            if ((n & 0x10) != 0) {
                string2 = "imported";
            }
            this(turquoiseAgentConfig, job2, agent, string, string2);
        }

        @NotNull
        public final TurquoiseAgentConfig getConfig() {
            return this.config;
        }

        @Nullable
        public final Job getJob() {
            return this.job;
        }

        public final void setJob(@Nullable Job job2) {
            this.job = job2;
        }

        @Nullable
        public final Agent getAgentInstance() {
            return this.agentInstance;
        }

        public final void setAgentInstance(@Nullable Agent agent) {
            this.agentInstance = agent;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @NotNull
        public final TurquoiseAgentConfig component1() {
            return this.config;
        }

        @Nullable
        public final Job component2() {
            return this.job;
        }

        @Nullable
        public final Agent component3() {
            return this.agentInstance;
        }

        @NotNull
        public final String component4() {
            return this.id;
        }

        @NotNull
        public final String component5() {
            return this.source;
        }

        @NotNull
        public final AgentEntry copy(@NotNull TurquoiseAgentConfig config2, @Nullable Job job2, @Nullable Agent agentInstance, @NotNull String id, @NotNull String source) {
            Intrinsics.checkNotNullParameter(config2, "config");
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter(source, "source");
            return new AgentEntry(config2, job2, agentInstance, id, source);
        }

        public static /* synthetic */ AgentEntry copy$default(AgentEntry agentEntry, TurquoiseAgentConfig turquoiseAgentConfig, Job job2, Agent agent, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                turquoiseAgentConfig = agentEntry.config;
            }
            if ((n & 2) != 0) {
                job2 = agentEntry.job;
            }
            if ((n & 4) != 0) {
                agent = agentEntry.agentInstance;
            }
            if ((n & 8) != 0) {
                string = agentEntry.id;
            }
            if ((n & 0x10) != 0) {
                string2 = agentEntry.source;
            }
            return agentEntry.copy(turquoiseAgentConfig, job2, agent, string, string2);
        }

        @NotNull
        public String toString() {
            return "AgentEntry(config=" + this.config + ", job=" + this.job + ", agentInstance=" + this.agentInstance + ", id=" + this.id + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result2 = this.config.hashCode();
            result2 = result2 * 31 + (this.job == null ? 0 : this.job.hashCode());
            result2 = result2 * 31 + (this.agentInstance == null ? 0 : this.agentInstance.hashCode());
            result2 = result2 * 31 + this.id.hashCode();
            result2 = result2 * 31 + this.source.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AgentEntry)) {
                return false;
            }
            AgentEntry agentEntry = (AgentEntry)other;
            if (!Intrinsics.areEqual(this.config, agentEntry.config)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.job, agentEntry.job)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.agentInstance, agentEntry.agentInstance)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.id, agentEntry.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.source, agentEntry.source);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J=\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001e"}, d2={"Lnet/turqu/agent/ui/AgentManager$AgentStatus;", "", "id", "", "config", "Lnet/turqu/model/TurquoiseAgentConfig;", "status", "duplicateOf", "source", "<init>", "(Ljava/lang/String;Lnet/turqu/model/TurquoiseAgentConfig;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getConfig", "()Lnet/turqu/model/TurquoiseAgentConfig;", "getStatus", "getDuplicateOf", "getSource", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "agent"})
    public static final class AgentStatus {
        @NotNull
        private final String id;
        @NotNull
        private final TurquoiseAgentConfig config;
        @NotNull
        private final String status;
        @Nullable
        private final String duplicateOf;
        @NotNull
        private final String source;

        public AgentStatus(@NotNull String id, @NotNull TurquoiseAgentConfig config2, @NotNull String status, @Nullable String duplicateOf, @NotNull String source) {
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter(config2, "config");
            Intrinsics.checkNotNullParameter(status, "status");
            Intrinsics.checkNotNullParameter(source, "source");
            this.id = id;
            this.config = config2;
            this.status = status;
            this.duplicateOf = duplicateOf;
            this.source = source;
        }

        public /* synthetic */ AgentStatus(String string, TurquoiseAgentConfig turquoiseAgentConfig, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            this(string, turquoiseAgentConfig, string2, string3, string4);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final TurquoiseAgentConfig getConfig() {
            return this.config;
        }

        @NotNull
        public final String getStatus() {
            return this.status;
        }

        @Nullable
        public final String getDuplicateOf() {
            return this.duplicateOf;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final TurquoiseAgentConfig component2() {
            return this.config;
        }

        @NotNull
        public final String component3() {
            return this.status;
        }

        @Nullable
        public final String component4() {
            return this.duplicateOf;
        }

        @NotNull
        public final String component5() {
            return this.source;
        }

        @NotNull
        public final AgentStatus copy(@NotNull String id, @NotNull TurquoiseAgentConfig config2, @NotNull String status, @Nullable String duplicateOf, @NotNull String source) {
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter(config2, "config");
            Intrinsics.checkNotNullParameter(status, "status");
            Intrinsics.checkNotNullParameter(source, "source");
            return new AgentStatus(id, config2, status, duplicateOf, source);
        }

        public static /* synthetic */ AgentStatus copy$default(AgentStatus agentStatus, String string, TurquoiseAgentConfig turquoiseAgentConfig, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = agentStatus.id;
            }
            if ((n & 2) != 0) {
                turquoiseAgentConfig = agentStatus.config;
            }
            if ((n & 4) != 0) {
                string2 = agentStatus.status;
            }
            if ((n & 8) != 0) {
                string3 = agentStatus.duplicateOf;
            }
            if ((n & 0x10) != 0) {
                string4 = agentStatus.source;
            }
            return agentStatus.copy(string, turquoiseAgentConfig, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "AgentStatus(id=" + this.id + ", config=" + this.config + ", status=" + this.status + ", duplicateOf=" + this.duplicateOf + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.config.hashCode();
            result2 = result2 * 31 + this.status.hashCode();
            result2 = result2 * 31 + (this.duplicateOf == null ? 0 : this.duplicateOf.hashCode());
            result2 = result2 * 31 + this.source.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AgentStatus)) {
                return false;
            }
            AgentStatus agentStatus = (AgentStatus)other;
            if (!Intrinsics.areEqual(this.id, agentStatus.id)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.config, agentStatus.config)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.status, agentStatus.status)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.duplicateOf, agentStatus.duplicateOf)) {
                return false;
            }
            return Intrinsics.areEqual(this.source, agentStatus.source);
        }
    }
}

