/*
 * Decompiled with CFR 0.152.
 */
package net.turqu.agent.device.impl;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.turqu.agent.device.DatabaseEngine;
import net.turqu.agent.device.QueryResult;
import net.turqu.model.DatabaseConfig;
import net.turqu.util.LoggerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001b\u0010\u0006\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lnet/turqu/agent/device/impl/SQLiteEngine;", "Lnet/turqu/agent/device/DatabaseEngine;", "databaseConfig", "Lnet/turqu/model/DatabaseConfig;", "<init>", "(Lnet/turqu/model/DatabaseConfig;)V", "connection", "Ljava/sql/Connection;", "getConnection", "()Ljava/sql/Connection;", "connection$delegate", "Lkotlin/Lazy;", "execute", "Lnet/turqu/agent/device/QueryResult;", "rawQuery", "", "agent"})
public final class SQLiteEngine
extends DatabaseEngine {
    @NotNull
    private final Lazy connection$delegate;

    public SQLiteEngine(@NotNull DatabaseConfig databaseConfig) {
        Intrinsics.checkNotNullParameter(databaseConfig, "databaseConfig");
        super(databaseConfig);
        this.connection$delegate = LazyKt.lazy(() -> SQLiteEngine.connection_delegate$lambda$0(databaseConfig));
    }

    @Override
    @NotNull
    public Connection getConnection() {
        Lazy lazy = this.connection$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "getValue(...)");
        return (Connection)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public QueryResult execute(@NotNull String rawQuery) {
        Intrinsics.checkNotNullParameter(rawQuery, "rawQuery");
        boolean querySuccess = false;
        List queryResultList = new ArrayList();
        try {
            AutoCloseable autoCloseable = this.getConnection().createStatement();
            Throwable throwable = null;
            try {
                Statement statement = (Statement)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = statement.executeQuery(rawQuery);
                Throwable throwable2 = null;
                try {
                    ResultSet rawQueryResult = (ResultSet)autoCloseable2;
                    boolean bl2 = false;
                    while (rawQueryResult.next()) {
                        HashMap row = new HashMap();
                        int i = 1;
                        int n = rawQueryResult.getMetaData().getColumnCount();
                        if (i <= n) {
                            while (true) {
                                ((Map)row).put(rawQueryResult.getMetaData().getColumnName(i), rawQueryResult.getObject(i));
                                if (i == n) break;
                                ++i;
                            }
                        }
                        queryResultList.add(row);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
            querySuccess = true;
        }
        catch (SQLException e) {
            LoggerKt.getLogger().error(e.getMessage());
        }
        return new QueryResult(querySuccess, queryResultList);
    }

    private static final Connection connection_delegate$lambda$0(DatabaseConfig $databaseConfig) {
        return DriverManager.getConnection("jdbc:sqlite:" + $databaseConfig.getAddress());
    }
}

