/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.cio;

import io.ktor.client.engine.ClientEngineClosedException;
import io.ktor.client.engine.HttpClientEngineBase;
import io.ktor.client.engine.HttpClientEngineCapability;
import io.ktor.client.engine.ProxyConfigJvmKt;
import io.ktor.client.engine.ProxyType;
import io.ktor.client.engine.UtilsKt;
import io.ktor.client.engine.cio.CIOEngine;
import io.ktor.client.engine.cio.CIOEngineConfig;
import io.ktor.client.engine.cio.ConnectionFactory;
import io.ktor.client.engine.cio.Endpoint;
import io.ktor.client.plugins.HttpTimeoutCapability;
import io.ktor.client.plugins.sse.SSECapability;
import io.ktor.client.plugins.websocket.WebSocketCapability;
import io.ktor.client.plugins.websocket.WebSocketExtensionsCapability;
import io.ktor.client.request.HttpRequestData;
import io.ktor.client.request.HttpResponseData;
import io.ktor.client.request.UnixSocketCapability;
import io.ktor.client.request.UnixSocketSettings;
import io.ktor.http.URLProtocol;
import io.ktor.http.URLProtocolKt;
import io.ktor.http.Url;
import io.ktor.network.selector.SelectorManager;
import io.ktor.network.selector.SelectorManagerKt;
import io.ktor.util.CoroutinesUtilsKt;
import io.ktor.util.collections.ConcurrentMap;
import io.ktor.util.network.NetworkAddressJvmKt;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.ClosedSendChannelException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ1\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e2\u000e\u0010\u0012\u001a\n\u0018\u00010\u0010j\u0004\u0018\u0001`\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR(\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c0\u001b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R \u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00150\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0014\u0010'\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0014\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010-\u001a\u00020,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020,8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b/\u0010.\u001a\u0004\b0\u00101R\u001c\u0010\u0012\u001a\n\u0018\u00010\u0010j\u0004\u0018\u0001`\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u00102\u00a8\u00063"}, d2={"Lio/ktor/client/engine/cio/CIOEngine;", "Lio/ktor/client/engine/HttpClientEngineBase;", "Lio/ktor/client/engine/cio/CIOEngineConfig;", "config", "<init>", "(Lio/ktor/client/engine/cio/CIOEngineConfig;)V", "Lio/ktor/client/request/HttpRequestData;", "data", "Lio/ktor/client/request/HttpResponseData;", "execute", "(Lio/ktor/client/request/HttpRequestData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "close", "()V", "Lio/ktor/http/Url;", "url", "Ljava/net/Proxy;", "Lio/ktor/client/engine/ProxyConfig;", "proxy", "Lio/ktor/client/request/UnixSocketSettings;", "unixSocket", "Lio/ktor/client/engine/cio/Endpoint;", "selectEndpoint", "(Lio/ktor/http/Url;Ljava/net/Proxy;Lio/ktor/client/request/UnixSocketSettings;)Lio/ktor/client/engine/cio/Endpoint;", "Lio/ktor/client/engine/cio/CIOEngineConfig;", "getConfig", "()Lio/ktor/client/engine/cio/CIOEngineConfig;", "", "Lio/ktor/client/engine/HttpClientEngineCapability;", "", "supportedCapabilities", "Ljava/util/Set;", "getSupportedCapabilities", "()Ljava/util/Set;", "Lio/ktor/util/collections/ConcurrentMap;", "", "endpoints", "Lio/ktor/util/collections/ConcurrentMap;", "Lio/ktor/network/selector/SelectorManager;", "selectorManager", "Lio/ktor/network/selector/SelectorManager;", "Lio/ktor/client/engine/cio/ConnectionFactory;", "connectionFactory", "Lio/ktor/client/engine/cio/ConnectionFactory;", "Lkotlin/coroutines/CoroutineContext;", "requestsJob", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "Ljava/net/Proxy;", "ktor-client-cio"})
@SourceDebugExtension(value={"SMAP\nCIOEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CIOEngine.kt\nio/ktor/client/engine/cio/CIOEngine\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,141:1\n216#2,2:142\n*S KotlinDebug\n*F\n+ 1 CIOEngine.kt\nio/ktor/client/engine/cio/CIOEngine\n*L\n102#1:142,2\n*E\n"})
public final class CIOEngine
extends HttpClientEngineBase {
    @NotNull
    private final CIOEngineConfig config;
    @NotNull
    private final Set<HttpClientEngineCapability<? extends Object>> supportedCapabilities;
    @NotNull
    private final ConcurrentMap<String, Endpoint> endpoints;
    @NotNull
    private final SelectorManager selectorManager;
    @NotNull
    private final ConnectionFactory connectionFactory;
    @NotNull
    private final CoroutineContext requestsJob;
    @NotNull
    private final CoroutineContext coroutineContext;
    @Nullable
    private final Proxy proxy;

    public CIOEngine(@NotNull CIOEngineConfig config2) {
        Proxy proxy;
        ProxyType type2;
        Intrinsics.checkNotNullParameter(config2, "config");
        super("ktor-cio");
        this.config = config2;
        HttpClientEngineCapability[] httpClientEngineCapabilityArray = new HttpClientEngineCapability[]{HttpTimeoutCapability.INSTANCE, WebSocketCapability.INSTANCE, WebSocketExtensionsCapability.INSTANCE, SSECapability.INSTANCE, UnixSocketCapability.INSTANCE};
        this.supportedCapabilities = SetsKt.setOf(httpClientEngineCapabilityArray);
        this.endpoints = new ConcurrentMap(0, 1, null);
        this.selectorManager = SelectorManagerKt.SelectorManager(this.getDispatcher());
        this.connectionFactory = new ConnectionFactory(this.selectorManager, this.getConfig().getMaxConnectionsCount(), this.getConfig().getEndpoint().getMaxConnectionsPerRoute());
        Proxy proxy2 = this.getConfig().getProxy();
        ProxyType proxyType = type2 = proxy2 != null ? ProxyConfigJvmKt.getType(proxy2) : null;
        switch (proxyType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[proxyType.ordinal()]) {
            case -1: 
            case 1: {
                proxy = null;
                break;
            }
            case 2: {
                proxy = this.getConfig().getProxy();
                break;
            }
            default: {
                throw new IllegalStateException("CIO engine does not currently support " + (Object)((Object)type2) + " proxies.");
            }
        }
        this.proxy = proxy;
        CoroutineContext parentContext = super.getCoroutineContext();
        Object e = parentContext.get(Job.Key);
        Intrinsics.checkNotNull(e);
        Job parent = (Job)e;
        CoroutineContext requestField = this.requestsJob = CoroutinesUtilsKt.SilentSupervisor(parent);
        this.coroutineContext = parentContext.plus(requestField);
        Object e2 = requestField.get(Job.Key);
        Intrinsics.checkNotNull(e2);
        Job requestJob = (Job)e2;
        SelectorManager selector = this.selectorManager;
        BuildersKt.launch(GlobalScope.INSTANCE, parentContext, CoroutineStart.ATOMIC, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(requestJob, selector, null){
            int label;
            final /* synthetic */ Job $requestJob;
            final /* synthetic */ SelectorManager $selector;
            {
                this.$requestJob = $requestJob;
                this.$selector = $selector;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = this.$requestJob.join(this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        try {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.$selector.close();
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Override
            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Override
            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @NotNull
    public CIOEngineConfig getConfig() {
        return this.config;
    }

    @NotNull
    public Set<HttpClientEngineCapability<? extends Object>> getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    @Override
    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object execute(@NotNull HttpRequestData var1_1, @NotNull Continuation<? super HttpResponseData> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ CIOEngine this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = data;
                $continuation.label = 1;
                v0 = UtilsKt.callContext($continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                data = (HttpRequestData)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                callContext = (CoroutineContext)v0;
lbl23:
                // 4 sources

                while (JobKt.isActive(this.getCoroutineContext())) {
                    unixSocket = (UnixSocketSettings)data.getCapabilityOrNull(UnixSocketCapability.INSTANCE);
                    endpoint = this.selectEndpoint(data.getUrl(), this.proxy, unixSocket);
                    $continuation.L$0 = data;
                    $continuation.L$1 = callContext;
                    $continuation.L$2 = endpoint;
                    $continuation.label = 2;
                    v1 = endpoint.execute(data, callContext, $continuation);
                    ** if (v1 != var10_5) goto lbl35
lbl34:
                    // 1 sources

                    return var10_5;
lbl35:
                    // 1 sources

                    ** GOTO lbl45
                }
            }
            break;
            case 2: {
                endpoint = (Endpoint)$continuation.L$2;
                callContext = (CoroutineContext)$continuation.L$1;
                data = (HttpRequestData)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v1 = var6_11 = $result;
                }
                catch (ClosedSendChannelException var7_9) {
                    ** GOTO lbl23
                }
lbl45:
                // 2 sources

                if (!JobKt.isActive(this.getCoroutineContext())) {
                    endpoint.close();
                }
                return var6_11;
            }
            {
                finally {
                    if (JobKt.isActive(this.getCoroutineContext())) ** GOTO lbl23
                    endpoint.close();
                    ** GOTO lbl23
                }
            }
        }
        throw new ClientEngineClosedException(null, 1, null);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void close() {
        super.close();
        Map $this$forEach$iv = this.endpoints;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            Endpoint endpoint = (Endpoint)entry.getValue();
            endpoint.close();
        }
        Object e = this.requestsJob.get(Job.Key);
        Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlinx.coroutines.CompletableJob");
        ((CompletableJob)e).complete();
    }

    private final Endpoint selectEndpoint(Url url2, Proxy proxy, UnixSocketSettings unixSocket) {
        String host = null;
        int port = 0;
        URLProtocol protocol = url2.getProtocol();
        if (proxy != null) {
            SocketAddress proxyAddress = ProxyConfigJvmKt.resolveAddress(proxy);
            host = NetworkAddressJvmKt.getHostname(proxyAddress);
            port = NetworkAddressJvmKt.getPort(proxyAddress);
        } else {
            host = url2.getHost();
            port = url2.getPort();
        }
        UnixSocketSettings unixSocketSettings = unixSocket;
        String endpointId = host + ':' + port + ':' + protocol + ':' + (unixSocketSettings != null ? unixSocketSettings.getPath() : null);
        return this.endpoints.computeIfAbsent(endpointId, () -> CIOEngine.selectEndpoint$lambda$2(protocol, host, port, proxy, this, unixSocket, endpointId));
    }

    private static final Unit selectEndpoint$lambda$2$lambda$1(CIOEngine this$0, String $endpointId) {
        this$0.endpoints.remove($endpointId);
        return Unit.INSTANCE;
    }

    private static final Endpoint selectEndpoint$lambda$2(URLProtocol $protocol, String $host, int $port, Proxy $proxy, CIOEngine this$0, UnixSocketSettings $unixSocket, String $endpointId) {
        boolean secure = URLProtocolKt.isSecure($protocol);
        return new Endpoint($host, $port, $proxy, secure, this$0.getConfig(), this$0.connectionFactory, this$0.getCoroutineContext(), () -> CIOEngine.selectEndpoint$lambda$2$lambda$1(this$0, $endpointId), $unixSocket);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProxyType.values().length];
            try {
                nArray[ProxyType.SOCKS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyType.HTTP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

