/*
 * Decompiled with CFR 0.152.
 */
package net.turqu.agent.device.impl;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.turqu.agent.device.StatsProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/turqu/agent/device/impl/StatsProviderImpl;", "Lnet/turqu/agent/device/StatsProvider;", "<init>", "()V", "osBean", "Lcom/sun/management/OperatingSystemMXBean;", "kotlin.jvm.PlatformType", "osName", "", "osVersion", "osArch", "getName", "getFreeMemory", "", "getTotalMemory", "getMemoryLoad", "getCpuLoad", "agent"})
public final class StatsProviderImpl
implements StatsProvider {
    private final OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);

    private final String osName() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        return string;
    }

    private final String osVersion() {
        String string = System.getProperty("os.version");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        return string;
    }

    private final String osArch() {
        String string = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        return InetAddress.getLocalHost().getHostName() + " - " + this.osName() + " " + this.osVersion() + " " + this.osArch();
    }

    @Override
    public long getFreeMemory() {
        return this.osBean.getFreeMemorySize();
    }

    @Override
    public long getTotalMemory() {
        return this.osBean.getTotalMemorySize();
    }

    @Override
    @NotNull
    public String getMemoryLoad() {
        long usedPhysicalMemorySize = this.getTotalMemory() - this.getFreeMemory();
        float loadPercent = (float)usedPhysicalMemorySize / (float)this.getTotalMemory() * 100.0f;
        return "%" + loadPercent;
    }

    @Override
    @NotNull
    public String getCpuLoad() {
        double percent = this.osBean.getSystemCpuLoad() * (double)100;
        return "%" + percent;
    }
}

