/*
 * Decompiled with CFR 0.152.
 */
package net.turqu.agent.device.impl;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.turqu.agent.device.DatabaseEngine;
import net.turqu.agent.device.QueryResult;
import net.turqu.model.DatabaseConfig;
import net.turqu.util.LoggerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lnet/turqu/agent/device/impl/SQLServerEngine;", "Lnet/turqu/agent/device/DatabaseEngine;", "databaseConfig", "Lnet/turqu/model/DatabaseConfig;", "<init>", "(Lnet/turqu/model/DatabaseConfig;)V", "backingConnection", "Ljava/sql/Connection;", "connection", "getConnection", "()Ljava/sql/Connection;", "execute", "Lnet/turqu/agent/device/QueryResult;", "rawQuery", "", "retryCount", "", "agent"})
public final class SQLServerEngine
extends DatabaseEngine {
    @Nullable
    private Connection backingConnection;

    public SQLServerEngine(@NotNull DatabaseConfig databaseConfig) {
        Intrinsics.checkNotNullParameter(databaseConfig, "databaseConfig");
        super(databaseConfig);
    }

    @Override
    @NotNull
    public Connection getConnection() {
        Connection connection = this.backingConnection;
        if (connection == null) {
            Connection connection2;
            StringBuilder stringBuilder;
            SQLServerEngine $this$_get_connection__u24lambda_u241 = this;
            boolean bl = false;
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            StringBuilder $this$_get_connection__u24lambda_u241_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$_get_connection__u24lambda_u241_u24lambda_u240.append("jdbc:sqlserver://" + $this$_get_connection__u24lambda_u241.getDatabaseConfig().getAddress() + ";databaseName=" + $this$_get_connection__u24lambda_u241.getDatabaseConfig().getName() + ";user=" + $this$_get_connection__u24lambda_u241.getDatabaseConfig().getUsername() + ";password=" + $this$_get_connection__u24lambda_u241.getDatabaseConfig().getPassword());
            String string = $this$_get_connection__u24lambda_u241.getDatabaseConfig().getOptions();
            boolean bl3 = string != null ? ((CharSequence)string).length() > 0 : false;
            if (bl3) {
                $this$_get_connection__u24lambda_u241_u24lambda_u240.append(";" + $this$_get_connection__u24lambda_u241.getDatabaseConfig().getOptions());
            }
            String connectionString = stringBuilder.toString();
            Connection it = connection2 = DriverManager.getConnection(connectionString);
            boolean bl4 = false;
            this.backingConnection = it;
            Connection connection3 = connection2;
            connection = connection3;
            Intrinsics.checkNotNullExpressionValue(connection3, "also(...)");
        }
        return connection;
    }

    @Override
    @NotNull
    public QueryResult execute(@NotNull String rawQuery) {
        Intrinsics.checkNotNullParameter(rawQuery, "rawQuery");
        return this.execute(rawQuery, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final QueryResult execute(String rawQuery, int retryCount) {
        boolean querySuccess = false;
        List queryResultList = new ArrayList();
        if (retryCount < 2) {
            try {
                AutoCloseable autoCloseable = this.getConnection().createStatement();
                Throwable throwable = null;
                try {
                    Statement statement = (Statement)autoCloseable;
                    boolean bl = false;
                    boolean hasResultSet = statement.execute(rawQuery);
                    if (hasResultSet) {
                        AutoCloseable autoCloseable2 = statement.getResultSet();
                        Throwable throwable2 = null;
                        try {
                            ResultSet rawQueryResult = (ResultSet)autoCloseable2;
                            boolean bl2 = false;
                            while (rawQueryResult.next()) {
                                HashMap row = new HashMap();
                                int i = 1;
                                int n = rawQueryResult.getMetaData().getColumnCount();
                                if (i <= n) {
                                    while (true) {
                                        Object obj = rawQueryResult.getObject(i);
                                        ((Map)row).put(rawQueryResult.getMetaData().getColumnName(i), obj instanceof Date ? ((Date)obj).toString() : obj);
                                        if (i == n) break;
                                        ++i;
                                    }
                                }
                                queryResultList.add(row);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
                querySuccess = true;
            }
            catch (Exception e) {
                LoggerKt.getLogger().error(e.getMessage(), e);
                this.backingConnection = null;
                return this.execute(rawQuery, retryCount + 1);
            }
        }
        return new QueryResult(querySuccess, queryResultList);
    }

    static /* synthetic */ QueryResult execute$default(SQLServerEngine sQLServerEngine, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return sQLServerEngine.execute(string, n);
    }
}

