/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.server.plugins.OriginConnectionPointKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B1\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0014J@\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b!\u0010\u0014R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010 \u001a\u0004\b\"\u0010\u0014R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010 \u001a\u0004\b#\u0010\u0014\u00a8\u0006%"}, d2={"Lio/ktor/server/routing/HostRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "", "", "hostList", "Lkotlin/text/Regex;", "hostPatterns", "", "portsList", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "Lio/ktor/server/routing/RoutingResolveContext;", "context", "segmentIndex", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lio/ktor/server/routing/RoutingResolveContext;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "()Ljava/lang/String;", "component1", "()Ljava/util/List;", "component2", "component3", "copy", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)Lio/ktor/server/routing/HostRouteSelector;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Ljava/util/List;", "getHostList", "getHostPatterns", "getPortsList", "Companion", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nHostsRoutingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostsRoutingBuilder.kt\nio/ktor/server/routing/HostRouteSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Parameters.kt\nio/ktor/http/Parameters$Companion\n*L\n1#1,175:1\n1761#2,3:176\n31#3:179\n*S KotlinDebug\n*F\n+ 1 HostsRoutingBuilder.kt\nio/ktor/server/routing/HostRouteSelector\n*L\n138#1:176,3\n149#1:179\n*E\n"})
public final class HostRouteSelector
extends RouteSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> hostList;
    @NotNull
    private final List<Regex> hostPatterns;
    @NotNull
    private final List<Integer> portsList;
    @NotNull
    public static final String HostNameParameter = "$RequestHost";
    @NotNull
    public static final String PortParameter = "$RequestPort";

    public HostRouteSelector(@NotNull List<String> hostList, @NotNull List<Regex> hostPatterns, @NotNull List<Integer> portsList) {
        Intrinsics.checkNotNullParameter(hostList, "hostList");
        Intrinsics.checkNotNullParameter(hostPatterns, "hostPatterns");
        Intrinsics.checkNotNullParameter(portsList, "portsList");
        this.hostList = hostList;
        this.hostPatterns = hostPatterns;
        this.portsList = portsList;
        if (!(!((Collection)this.hostList).isEmpty() || !((Collection)this.hostPatterns).isEmpty() || !((Collection)this.portsList).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final List<String> getHostList() {
        return this.hostList;
    }

    @NotNull
    public final List<Regex> getHostPatterns() {
        return this.hostPatterns;
    }

    @NotNull
    public final List<Integer> getPortsList() {
        return this.portsList;
    }

    @Override
    @Nullable
    public Object evaluate(@NotNull RoutingResolveContext context, int segmentIndex, @NotNull Continuation<? super RouteSelectorEvaluation> $completion) {
        ParametersBuilder parametersBuilder;
        String requestHost = OriginConnectionPointKt.getOrigin(context.getCall().getRequest()).getServerHost();
        int requestPort = OriginConnectionPointKt.getOrigin(context.getCall().getRequest()).getServerPort();
        if (!((Collection)this.hostList).isEmpty() || !((Collection)this.hostPatterns).isEmpty()) {
            boolean matches2;
            boolean matches1;
            block8: {
                boolean bl;
                matches1 = this.hostList.contains(requestHost);
                if (!matches1) {
                    Iterable $this$any$iv = this.hostPatterns;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Regex it = (Regex)element$iv;
                            boolean bl2 = false;
                            if (!it.matches(requestHost)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                } else {
                    bl = matches2 = false;
                }
            }
            if (!matches1 && !matches2) {
                return RouteSelectorEvaluation.Companion.getFailed();
            }
        }
        if (!((Collection)this.portsList).isEmpty() && !this.portsList.contains(Boxing.boxInt(requestPort))) {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        Parameters.Companion this_$iv = Parameters.Companion;
        boolean $i$f$build = false;
        ParametersBuilder $this$evaluate_u24lambda_u241 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
        boolean bl = false;
        $this$evaluate_u24lambda_u241.append(HostNameParameter, requestHost);
        $this$evaluate_u24lambda_u241.append(PortParameter, String.valueOf(requestPort));
        Parameters params = parametersBuilder.build();
        return new RouteSelectorEvaluation.Success(1.0, params, 0, 4, null);
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.hostList + ", " + this.hostPatterns + ", " + this.portsList + ')';
    }

    @NotNull
    public final List<String> component1() {
        return this.hostList;
    }

    @NotNull
    public final List<Regex> component2() {
        return this.hostPatterns;
    }

    @NotNull
    public final List<Integer> component3() {
        return this.portsList;
    }

    @NotNull
    public final HostRouteSelector copy(@NotNull List<String> hostList, @NotNull List<Regex> hostPatterns, @NotNull List<Integer> portsList) {
        Intrinsics.checkNotNullParameter(hostList, "hostList");
        Intrinsics.checkNotNullParameter(hostPatterns, "hostPatterns");
        Intrinsics.checkNotNullParameter(portsList, "portsList");
        return new HostRouteSelector(hostList, hostPatterns, portsList);
    }

    public static /* synthetic */ HostRouteSelector copy$default(HostRouteSelector hostRouteSelector, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = hostRouteSelector.hostList;
        }
        if ((n & 2) != 0) {
            list2 = hostRouteSelector.hostPatterns;
        }
        if ((n & 4) != 0) {
            list3 = hostRouteSelector.portsList;
        }
        return hostRouteSelector.copy(list, list2, list3);
    }

    public int hashCode() {
        int result2 = ((Object)this.hostList).hashCode();
        result2 = result2 * 31 + ((Object)this.hostPatterns).hashCode();
        result2 = result2 * 31 + ((Object)this.portsList).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HostRouteSelector)) {
            return false;
        }
        HostRouteSelector hostRouteSelector = (HostRouteSelector)other;
        if (!Intrinsics.areEqual(this.hostList, hostRouteSelector.hostList)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.hostPatterns, hostRouteSelector.hostPatterns)) {
            return false;
        }
        return Intrinsics.areEqual(this.portsList, hostRouteSelector.portsList);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lio/ktor/server/routing/HostRouteSelector$Companion;", "", "<init>", "()V", "", "HostNameParameter", "Ljava/lang/String;", "PortParameter", "ktor-server-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

