/*
 * Copyright (c) 2007, 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */


package org.graalvm.compiler.jtt.except;

import org.junit.Test;

import org.graalvm.compiler.jtt.JTTTest;

/*
 */
public class BC_invokespecial01 extends JTTTest {

    private static class TestClass {
        @SuppressWarnings("static-method")
        private boolean method() {
            return true;
        }
    }

    private static final TestClass obj = new TestClass();

    public static boolean test(int arg) {
        TestClass object = null;
        if (arg == 0) {
            object = obj;
        }
        return object.method();
    }

    @Test
    public void run0() throws Throwable {
        runTest("test", 0);
    }

    @Test
    public void run1() throws Throwable {
        runTest("test", 1);
    }

}
